<?php
/* --------------------------------------------------------------
 LegacyConfigurationQbRepository.php 2020-01-08
 Gambio GmbH
 http://www.gambio.de
 Copyright (c) 08 Gambio GmbH
 Released under the GNU General Public License (Version 2)
 [http://www.gnu.org/licenses/gpl-2.0.html]
 --------------------------------------------------------------
 */

namespace Gambio\Core\Configuration\Compatibility\Repositories;

use Doctrine\DBAL\Connection;
use Gambio\Core\Configuration\Compatibility\GmSetContentRepository;

/**
 * Class LegacyConfigurationQbRepository
 * @package    Gambio\Core\Configuration\Repositories
 *
 * @codeCoverageIgnore
 * @deprecated This repository was created to abstract the gm_set_content functionality and shouldn't be used in new
 *             domains.
 */
class GmSetContentQbRepository implements GmSetContentRepository
{
    private const TABLE_NAME = 'gx_configurations';
    
    /**
     * @var Connection
     */
    private $connection;
    
    
    /**
     * LegacyConfigurationQbRepository constructor.
     *
     * @param Connection $connection
     */
    public function __construct(Connection $connection)
    {
        $this->connection = $connection;
    }
    
    
    /**
     * @inheritDoc
     */
    public function update(string $key, string $value, int $languageId, int $groupId = 0): void
    {
        $prefix = 'gm_configuration/';
        
        // apply legacy prefix, if not already done
        if (!$this->strBeginsWith($prefix, $key)) {
            $key = $prefix . $key;
        }
        
        if ($this->configExists($key, $languageId)) {
            $set   = [$this->connection->quoteIdentifier('value') => $value, 'legacy_group_id' => $groupId];
            $where = [$this->connection->quoteIdentifier('key') => $key, 'language_id' => $languageId];
            $this->connection->update(self::TABLE_NAME, $set, $where);
            
            return;
        }
        
        $set = [
            $this->connection->quoteIdentifier('key')             => $key,
            $this->connection->quoteIdentifier('value')           => $value,
            $this->connection->quoteIdentifier('language_id')     => $languageId,
            $this->connection->quoteIdentifier('legacy_group_id') => $groupId,
        ];
        $this->connection->insert(self::TABLE_NAME, $set);
    }
    
    
    /**
     * Checks if configuration item already exists.
     *
     * @param string $key
     * @param int    $languageId
     *
     * @return bool
     */
    private function configExists(string $key, int $languageId): bool
    {
        $qb = $this->connection->createQueryBuilder();
        
        return $qb->select('*')
                   ->from(self::TABLE_NAME)
                   ->where('`key` = ' . $qb->createNamedParameter($key))
                   ->andWhere('language_id = ' . $qb->createNamedParameter($languageId))
                   ->execute()
                   ->rowCount() > 0;
    }
    
    
    /**
     * Checks if $subject begins with string equals $begin.
     *
     * @param string $begin
     * @param string $subject
     *
     * @return bool
     */
    private function strBeginsWith(string $begin, string $subject): bool
    {
        return strpos($subject, $begin) === 0;
    }
}